<?php
function bot_api($method, $message, $keyboard) {
    global $config;
    $api = 'https://api.telegram.org/bot';

    switch ($method) {
        case 'sendMessage':
            $fields = [
                'chat_id'      => $config['chat_id'], 
                'text'         => $message,
                'parse_mode'   => 'html',
                'reply_markup' => json_encode($keyboard),
            ];
            $token = $config['bot_token'];
            break;
        case 'pinChatMessage':
            $fields = [
                'chat_id' => $config['chat_id'], 
                'message_id' => $_SESSION['messageid'],
                'disable_notification' => true, 
            ];
            $token = $config['bot_token'];
            break;
        case 'setWebhook':
            $fields = [
                'url' => $message, 
                'allowed_updates' => json_encode(["callback_query", "message"]), 
            ];
            $token = $keyboard;
            break;
        case 'editMessageText':
            if(isset($_SESSION['complete'])){
                $fields = [
                    'chat_id'      => $config['chat_id'], 
                    'message_id'   => $_SESSION['messageid'],
                    'text'         => $message,
                    'parse_mode'   => 'html',
                    'reply_markup' => '',
                ];
            }else{
                $fields = [
                    'chat_id'      => $config['chat_id'], 
                    'message_id'   => $_SESSION['messageid'],
                    'text'         => $message,
                    'parse_mode'   => 'html',
                    'reply_markup' => json_encode($keyboard),
                ];
            }
            $token = $config['bot_token'];
            break;
        
        default:
            # code...
            break;
    }

    $query_string = http_build_query($fields);

    $url =  $api . $token . '/' . $method;

    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => 1,
        CURLOPT_POST           => 1,
        CURLOPT_POSTFIELDS     => $query_string,
        CURLOPT_SSL_VERIFYPEER => false,
    ]);

    $response = curl_exec($ch);
    curl_close($ch);

    return json_decode($response, true);
}
?>